SET QUOTED_IDENTIFIER ON
GO

/*****************************************************************************
 *
 * Upgrade Scripts
 * 
 * From Version: 5.5.1.1
 * To Version:   <current>
 *
 ******************************************************************************/
 
 --Set Script Name
 IF OBJECT_ID('tempdb..#SCRIPT') IS NOT NULL
    DROP TABLE #SCRIPT

 CREATE TABLE 
        #SCRIPT
       ([ScriptName]          VARCHAR(MAX) COLLATE DATABASE_DEFAULT,
        [CompatibleVersion]   VARCHAR(50),
        [MajorVersion]        INT,
        [MinorVersion]        INT,
        [Build]               INT,
        [Revision]            INT)

--Create Script Entry. This can be updated below
SET NOCOUNT ON
INSERT
  INTO #SCRIPT
      ([ScriptName],
       [CompatibleVersion],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision])
VALUES('001 UpgradeScripts.sql',
       'Build 5.5.1.1',
       5,
       5,
       1,
       1)
SET NOCOUNT OFF

--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 5,
                   [Build] = 1,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.5.1.1'
SET NOCOUNT OFF
--Keep this to be safe END

/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.5.1.1000
 * Block IS **WORK IN PROGRESS** - You can still make changes to this block
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1000, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.5.1.1000'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.5.1.1000
 * Block IS **WORK IN PROGRESS** - You can still make changes to this block
 * END
 *
 ****************************************************************************************************************/

--DELETE [dbo].[KYScriptLog] WHERE [COMMENT] LIKE '% **WIP - SUCCESS**' 
/****************************************************************************************************************
 * DO NOT INSERT CODE HERE. Put it before "Log the successful execution of this block" - see above
 ****************************************************************************************************************/
/* The following block of code MUST remain at the end of this file START */
DELETE KGC
  FROM [dbo].[KHCtlGroupControls] KGC
       INNER JOIN [dbo].[KHCtlMaster] KCM
               ON KCM.[id] = KGC.[masterid]
       INNER JOIN [dbo].[KHCtlGroups] KCG
               ON KCG.[id] = KGC.[groupid]
 WHERE KCM.[Deleted] = 1
    OR KCM.[FriendlyName] = ''
GO
/* The following block of code MUST remain at the end of this file END */
